/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PMIDlet;

public class PCanvas
extends Canvas {
    public static Image buffer;
    public static int imageMode;
    protected PMIDlet midlet;
    protected boolean suspended;
    protected Graphics bufferg;
    protected int width;
    protected int height;
    protected int colorMode;
    protected boolean colorModeRGB255;
    protected int colorMaxX;
    protected int colorMaxY;
    protected int colorMaxZ;
    protected int colorMaxA;
    protected boolean stroke;
    protected int strokeWidth;
    protected int strokeColor;
    protected boolean fill;
    protected int fillColor;
    protected int rectMode;
    protected int ellipseMode;
    protected int shapeMode;
    protected int[] vertex;
    protected int vertexIndex;
    protected int[] curveVertex;
    protected int curveVertexIndex;
    protected int[] stack;
    protected int stackIndex;
    protected PFont textFont;
    protected int textAlign;
    protected int textLeading;
    protected static final int EDGE_X = 0;
    protected static final int EDGE_DX = 1;
    protected static final int EDGE_DY = 2;
    protected static final int EDGE_X1 = 3;
    protected static final int EDGE_Y1 = 4;
    protected static final int EDGE_X2 = 5;
    protected static final int EDGE_Y2 = 6;
    protected static final int EDGE_ARRAY_SIZE = 7;

    public PCanvas(PMIDlet pMIDlet) {
        this.midlet = pMIDlet;
        this.width = this.getWidth();
        this.height = this.getHeight();
        buffer = Image.createImage((int)this.width, (int)this.height);
        this.bufferg = buffer.getGraphics();
        this.colorMode = 0;
        this.colorModeRGB255 = true;
        this.colorMaxA = 255;
        this.colorMaxZ = 255;
        this.colorMaxY = 255;
        this.colorMaxX = 255;
        this.stroke = true;
        this.strokeColor = 0;
        this.strokeWidth = 1;
        this.fill = true;
        this.fillColor = 0xFFFFFF;
        this.rectMode = 2;
        this.ellipseMode = 0;
        imageMode = 2;
        this.shapeMode = -1;
        this.vertex = new int[16];
        this.vertexIndex = 0;
        this.curveVertex = new int[8];
        this.curveVertexIndex = 0;
        this.stack = new int[6];
        this.textAlign = 2;
        this.background(200);
    }

    protected void paint(Graphics graphics) {
        graphics.drawImage(buffer, 0, 0, 20);
    }

    protected void keyPressed(int n) {
        this.midlet.enqueueEvent((byte)1, n, null);
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
        this.midlet.enqueueEvent((byte)2, n, null);
    }

    protected void pointerPressed(int n, int n2) {
        int n3 = n << 16 | n2 & 0xFFFF;
        this.midlet.enqueueEvent((byte)5, n3, null);
    }

    protected void pointerDragged(int n, int n2) {
        int n3 = n << 16 | n2 & 0xFFFF;
        this.midlet.enqueueEvent((byte)6, n3, null);
    }

    protected void pointerReleased(int n, int n2) {
        int n3 = n << 16 | n2 & 0xFFFF;
        this.midlet.enqueueEvent((byte)7, n3, null);
    }

    public void point(int n, int n2) {
        if (this.stroke) {
            this.bufferg.setColor(this.strokeColor);
            this.bufferg.drawLine(n, n2, n, n2);
        }
    }

    public void line(int n, int n2, int n3, int n4) {
        if (this.stroke) {
            this.bufferg.setColor(this.strokeColor);
            this.bufferg.drawLine(n, n2, n3, n4);
            if (this.strokeWidth > 1) {
                int n5;
                boolean bl;
                boolean bl2 = bl = Math.abs(n4 - n2) > Math.abs(n3 - n);
                if (bl) {
                    n5 = n;
                    n = n2;
                    n2 = n5;
                    n5 = n3;
                    n3 = n4;
                    n4 = n5;
                }
                if (n > n3) {
                    n5 = n;
                    n = n3;
                    n3 = n5;
                    n5 = n2;
                    n2 = n4;
                    n4 = n5;
                }
                n5 = n3 - n;
                int n6 = n4 > n2 ? n4 - n2 : n2 - n4;
                int n7 = 0;
                int n8 = this.strokeWidth >> 1;
                int n9 = n2 - n8;
                int n10 = n2 < n4 ? 1 : -1;
                int n11 = n3 - n8;
                for (int i = n - n8; i <= n11; ++i) {
                    if (bl) {
                        this.bufferg.fillArc(n9, i, this.strokeWidth, this.strokeWidth, 0, 360);
                    } else {
                        this.bufferg.fillArc(i, n9, this.strokeWidth, this.strokeWidth, 0, 360);
                    }
                    if (2 * (n7 += n6) < n5) continue;
                    n9 += n10;
                    n7 -= n5;
                }
            }
        }
    }

    public void triangle(int n, int n2, int n3, int n4, int n5, int n6) {
        this.shapeMode = 8;
        this.vertex[0] = n;
        this.vertex[1] = n2;
        this.vertex[2] = n3;
        this.vertex[3] = n4;
        this.vertex[4] = n5;
        this.vertex[5] = n6;
        this.vertexIndex = 6;
        this.endShape();
    }

    public void quad(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.shapeMode = 8;
        this.vertex[0] = n;
        this.vertex[1] = n2;
        this.vertex[2] = n3;
        this.vertex[3] = n4;
        this.vertex[4] = n5;
        this.vertex[5] = n6;
        this.vertex[6] = n7;
        this.vertex[7] = n8;
        this.vertexIndex = 8;
        this.endShape();
    }

    public void rect(int n, int n2, int n3, int n4) {
        switch (this.rectMode) {
            case 3: {
                int n5 = n;
                n = Math.min(n, n3);
                n3 = Math.abs(n - n5);
                n5 = n2;
                n2 = Math.min(n2, n4);
                n4 = Math.abs(n2 - n5);
                break;
            }
            case 0: {
                n -= n3 / 2;
                n2 -= n4 / 2;
            }
        }
        if (this.fill) {
            this.bufferg.setColor(this.fillColor);
            this.bufferg.fillRect(n, n2, n3, n4);
        }
        if (this.stroke) {
            this.bufferg.setColor(this.strokeColor);
            this.bufferg.drawRect(n, n2, n3, n4);
        }
    }

    public void rectMode(int n) {
        if (n >= 0 && n <= 2) {
            this.rectMode = n;
        }
    }

    public void ellipse(int n, int n2, int n3, int n4) {
        switch (this.ellipseMode) {
            case 3: {
                int n5 = n;
                n = Math.min(n, n3);
                n3 = Math.abs(n - n5);
                n5 = n2;
                n2 = Math.min(n2, n4);
                n4 = Math.abs(n2 - n5);
                break;
            }
            case 0: {
                n -= n3 / 2;
                n2 -= n4 / 2;
                break;
            }
            case 1: {
                n -= n3;
                n2 -= n4;
                n3 *= 2;
                n4 *= 2;
            }
        }
        if (this.fill) {
            this.bufferg.setColor(this.fillColor);
            this.bufferg.fillArc(n, n2, n3, n4, 0, 360);
        }
        if (this.stroke) {
            this.bufferg.setColor(this.strokeColor);
            this.bufferg.drawArc(n, n2, n3, n4, 0, 360);
        }
    }

    public void ellipseMode(int n) {
        if (n >= 0 && n <= 3) {
            this.ellipseMode = n;
        }
    }

    public void curve(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.beginShape(2);
        this.curveVertex(n, n2);
        this.curveVertex(n, n2);
        this.curveVertex(n3, n4);
        this.curveVertex(n5, n6);
        this.curveVertex(n7, n8);
        this.curveVertex(n7, n8);
        this.endShape();
    }

    public void bezier(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.beginShape(2);
        this.vertex(n, n2);
        this.bezierVertex(n3, n4, n5, n6, n7, n8);
        this.endShape();
    }

    public void strokeWeight(int n) {
        this.strokeWidth = n;
    }

    public void beginShape(int n) {
        this.shapeMode = n >= 0 && n <= 8 ? n : 0;
        this.vertexIndex = 0;
        this.curveVertexIndex = 0;
    }

    public void endShape() {
        int n;
        int n2;
        switch (this.shapeMode) {
            case 0: {
                n2 = 0;
                n = 2;
                break;
            }
            case 1: {
                n2 = 2;
                n = 4;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                n = 2;
                break;
            }
            case 4: {
                n2 = 4;
                n = 6;
                break;
            }
            case 5: {
                n2 = 4;
                n = 2;
                break;
            }
            case 6: {
                n2 = 6;
                n = 8;
                break;
            }
            case 7: {
                n2 = 6;
                n = 4;
                break;
            }
            case 8: {
                this.polygon(0, this.vertexIndex - 2);
                return;
            }
            default: {
                return;
            }
        }
        while (n2 < this.vertexIndex) {
            switch (this.shapeMode) {
                case 0: {
                    this.point(this.vertex[n2], this.vertex[n2 + 1]);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.line(this.vertex[n2 - 2], this.vertex[n2 - 1], this.vertex[n2], this.vertex[n2 + 1]);
                    break;
                }
                case 4: 
                case 5: {
                    this.polygon(n2 - 4, n2);
                    break;
                }
                case 6: 
                case 7: {
                    this.polygon(n2 - 6, n2);
                }
            }
            n2 += n;
        }
        if (this.shapeMode == 3 && this.vertexIndex >= 2) {
            this.line(this.vertex[this.vertexIndex - 2], this.vertex[this.vertexIndex - 1], this.vertex[0], this.vertex[1]);
        }
        this.vertexIndex = 0;
    }

    protected void polygon(int n, int n2) {
        if (n2 >= n + 2) {
            if (n2 >= n + 4 && this.fill) {
                int[] nArray;
                int n3;
                int[] nArray2;
                int n4;
                this.bufferg.setColor(this.fillColor);
                Vector<int[]> vector = new Vector<int[]>();
                int n5 = 0;
                int n6 = Integer.MAX_VALUE;
                int n7 = Integer.MIN_VALUE;
                for (n4 = n; n4 <= n2; n4 += 2) {
                    nArray2 = new int[7];
                    if (n4 == n) {
                        if (this.vertex[n + 1] < this.vertex[n2 + 1]) {
                            nArray2[3] = this.vertex[n];
                            nArray2[4] = this.vertex[n + 1];
                            nArray2[5] = this.vertex[n2];
                            nArray2[6] = this.vertex[n2 + 1];
                        } else {
                            nArray2[3] = this.vertex[n2];
                            nArray2[4] = this.vertex[n2 + 1];
                            nArray2[5] = this.vertex[n];
                            nArray2[6] = this.vertex[n + 1];
                        }
                    } else if (this.vertex[n4 - 1] < this.vertex[n4 + 1]) {
                        nArray2[3] = this.vertex[n4 - 2];
                        nArray2[4] = this.vertex[n4 - 1];
                        nArray2[5] = this.vertex[n4];
                        nArray2[6] = this.vertex[n4 + 1];
                    } else {
                        nArray2[3] = this.vertex[n4];
                        nArray2[4] = this.vertex[n4 + 1];
                        nArray2[5] = this.vertex[n4 - 2];
                        nArray2[6] = this.vertex[n4 - 1];
                    }
                    nArray2[0] = nArray2[3];
                    nArray2[1] = nArray2[5] - nArray2[3];
                    nArray2[2] = nArray2[6] - nArray2[4];
                    n6 = Math.min(nArray2[4], n6);
                    n7 = Math.max(nArray2[6], n7);
                    for (n3 = 0; n3 < n5; ++n3) {
                        nArray = (int[])vector.elementAt(n3);
                        if (nArray2[4] < nArray[4]) {
                            vector.insertElementAt(nArray2, n3);
                            nArray2 = null;
                            break;
                        }
                        if (nArray2[4] != nArray[4] || nArray2[3] >= nArray[3]) continue;
                        vector.insertElementAt(nArray2, n3);
                        nArray2 = null;
                        break;
                    }
                    if (nArray2 != null) {
                        vector.addElement(nArray2);
                    }
                    ++n5;
                }
                Vector<int[]> vector2 = new Vector<int[]>();
                int n8 = 0;
                for (int i = n6; i <= n7; ++i) {
                    for (n4 = n8 - 1; n4 >= 0; --n4) {
                        nArray2 = (int[])vector2.elementAt(n4);
                        if (nArray2[6] <= i) {
                            vector2.removeElementAt(n4);
                            --n8;
                            continue;
                        }
                        nArray2[0] = (i - nArray2[4]) * nArray2[1] / nArray2[2] + nArray2[3];
                    }
                    Vector<int[]> vector3 = new Vector<int[]>();
                    for (n4 = 0; n4 < n8; ++n4) {
                        nArray2 = (int[])vector2.elementAt(n4);
                        for (n3 = 0; n3 < n4; ++n3) {
                            nArray = (int[])vector3.elementAt(n3);
                            if (nArray2[0] >= nArray[0]) continue;
                            vector3.insertElementAt(nArray2, n3);
                            nArray2 = null;
                            break;
                        }
                        if (nArray2 == null) continue;
                        vector3.addElement(nArray2);
                    }
                    vector2 = vector3;
                    for (n4 = 0; n4 < n5 && (nArray2 = (int[])vector.elementAt(n4))[4] == i; ++n4) {
                        for (n3 = 0; n3 < n8; ++n3) {
                            nArray = (int[])vector2.elementAt(n3);
                            if (nArray2[0] >= nArray[0]) continue;
                            vector2.insertElementAt(nArray2, n3);
                            nArray2 = null;
                            break;
                        }
                        if (nArray2 != null) {
                            vector2.addElement(nArray2);
                        }
                        ++n8;
                        vector.removeElementAt(n4);
                        --n5;
                        --n4;
                    }
                    for (n4 = 1; n4 < n8; n4 += 2) {
                        nArray2 = (int[])vector2.elementAt(n4 - 1);
                        nArray = (int[])vector2.elementAt(n4);
                        this.bufferg.drawLine(nArray2[0], i, nArray[0], i);
                    }
                }
            }
            if (this.stroke) {
                this.bufferg.setColor(this.strokeColor);
                for (int i = n + 2; i <= n2; i += 2) {
                    this.line(this.vertex[i - 2], this.vertex[i - 1], this.vertex[i], this.vertex[i + 1]);
                }
                this.line(this.vertex[n2], this.vertex[n2 + 1], this.vertex[n], this.vertex[n + 1]);
            }
        }
    }

    public void vertex(int n, int n2) {
        this.vertex[this.vertexIndex] = n;
        ++this.vertexIndex;
        this.vertex[this.vertexIndex] = n2;
        ++this.vertexIndex;
        int n3 = this.vertex.length;
        if (this.vertexIndex == n3) {
            int[] nArray = this.vertex;
            this.vertex = new int[n3 * 2];
            System.arraycopy(nArray, 0, this.vertex, 0, n3);
        }
    }

    public void curveVertex(int n, int n2) {
        this.curveVertex[this.curveVertexIndex] = n << 8;
        ++this.curveVertexIndex;
        this.curveVertex[this.curveVertexIndex] = n2 << 8;
        ++this.curveVertexIndex;
        if (this.curveVertexIndex == 8) {
            int n3 = 128;
            int n4 = (this.curveVertex[4] - this.curveVertex[0]) * n3 >> 8;
            int n5 = (this.curveVertex[6] - this.curveVertex[2]) * n3 >> 8;
            int n6 = (this.curveVertex[5] - this.curveVertex[1]) * n3 >> 8;
            int n7 = (this.curveVertex[7] - this.curveVertex[3]) * n3 >> 8;
            this.plotCurveVertices(this.curveVertex[2], this.curveVertex[3], this.curveVertex[4], this.curveVertex[5], n4, n5, n6, n7);
            for (int i = 0; i < 6; ++i) {
                this.curveVertex[i] = this.curveVertex[i + 2];
            }
            this.curveVertexIndex = 6;
        }
    }

    public void bezierVertex(int n, int n2, int n3, int n4, int n5, int n6) {
        this.vertexIndex -= 2;
        int n7 = this.vertex[this.vertexIndex] << 8;
        int n8 = this.vertex[this.vertexIndex + 1] << 8;
        int n9 = 768;
        int n10 = ((n <<= 8) - n7) * n9 >> 8;
        int n11 = ((n5 <<= 8) - (n3 <<= 8)) * n9 >> 8;
        int n12 = ((n2 <<= 8) - n8) * n9 >> 8;
        int n13 = ((n6 <<= 8) - (n4 <<= 8)) * n9 >> 8;
        this.plotCurveVertices(n7, n8, n5, n6, n10, n11, n12, n13);
    }

    protected void plotCurveVertices(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.vertex(n >> 8, n2 >> 8);
        for (int i = 0; i < 256; i += 26) {
            int n9 = i * i >> 8;
            int n10 = i * n9 >> 8;
            int n11 = (512 * n10 >> 8) - (768 * n9 >> 8) + 256;
            int n12 = (-512 * n10 >> 8) + (768 * n9 >> 8);
            int n13 = n10 - (512 * n9 >> 8) + i;
            int n14 = n10 - n9;
            int n15 = (n11 * n >> 8) + (n12 * n3 >> 8) + (n13 * n5 >> 8) + (n14 * n6 >> 8);
            int n16 = (n11 * n2 >> 8) + (n12 * n4 >> 8) + (n13 * n7 >> 8) + (n14 * n8 >> 8);
            this.vertex(n15 >> 8, n16 >> 8);
        }
        this.vertex(n3 >> 8, n4 >> 8);
    }

    public void translate(int n, int n2) {
        this.bufferg.translate(n, n2);
    }

    public void clip(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = this.bufferg.getClipX();
        int n8 = this.bufferg.getClipY();
        int n9 = n7 + this.bufferg.getClipWidth();
        int n10 = n8 + this.bufferg.getClipHeight();
        if (n < n9 && n5 > n7 && n2 < n10 && n6 > n8) {
            int n11 = Math.max(n, n7);
            int n12 = Math.max(n2, n8);
            int n13 = Math.min(n5, n9) - n11;
            int n14 = Math.min(n6, n10) - n12;
            this.bufferg.setClip(n11, n12, n13, n14);
        }
    }

    public void pushMatrix() {
        if (this.stackIndex == this.stack.length) {
            int[] nArray = this.stack;
            this.stack = new int[this.stackIndex * 2];
            System.arraycopy(nArray, 0, this.stack, 0, this.stackIndex);
        }
        this.stack[this.stackIndex++] = this.bufferg.getTranslateX();
        this.stack[this.stackIndex++] = this.bufferg.getTranslateY();
        this.stack[this.stackIndex++] = this.bufferg.getClipX();
        this.stack[this.stackIndex++] = this.bufferg.getClipY();
        this.stack[this.stackIndex++] = this.bufferg.getClipWidth();
        this.stack[this.stackIndex++] = this.bufferg.getClipHeight();
    }

    public void popMatrix() {
        if (this.stackIndex > 0) {
            this.stackIndex -= 6;
            int n = this.stack[this.stackIndex++];
            int n2 = this.stack[this.stackIndex++];
            this.bufferg.translate(n - this.bufferg.getTranslateX(), n2 - this.bufferg.getTranslateY());
            int n3 = this.stack[this.stackIndex++];
            int n4 = this.stack[this.stackIndex++];
            int n5 = this.stack[this.stackIndex++];
            int n6 = this.stack[this.stackIndex++];
            this.bufferg.setClip(n3, n4, n5, n6);
            this.stackIndex -= 6;
        }
    }

    public void resetMatrix() {
        this.stackIndex = 0;
        this.bufferg.translate(-this.bufferg.getTranslateX(), -this.bufferg.getTranslateY());
        this.bufferg.setClip(0, 0, this.width, this.height);
    }

    public void background(int n) {
        if ((n & 0xFF000000) == 0 && n <= this.colorMaxX) {
            this.bufferg.setColor(this.color(n, this.colorMaxA));
        } else {
            this.bufferg.setColor(n);
        }
        this.bufferg.fillRect(0, 0, this.width, this.height);
    }

    public void background(int n, int n2, int n3) {
        this.bufferg.setColor(this.color(n, n2, n3));
        this.bufferg.fillRect(0, 0, this.width, this.height);
    }

    public void background(PImage pImage) {
        this.image(pImage, this.width - pImage.width >> 1, this.height - pImage.height >> 1);
    }

    public void image(PImage pImage, int n, int n2) {
        pImage.draw(this.bufferg, n, n2);
    }

    public void image(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6) {
        if (imageMode == 3) {
            n3 -= n;
            n4 -= n2;
        }
        this.pushMatrix();
        this.clip(n5, n6, n3, n4);
        pImage.draw(this.bufferg, n5 - n, n6 - n2);
        this.popMatrix();
    }

    public void imageMode(int n) {
        if (n != 2 && n != 3) {
            throw new RuntimeException("Invalid imageMode");
        }
        imageMode = n;
    }

    public void textFont(PFont pFont) {
        this.textFont = pFont;
        this.textLeading = pFont.height;
    }

    public void colorMode(int n) {
        if (n == 0 || n == 1) {
            this.colorMode = n;
        }
        this.colorModeRGB255 = false;
        if (this.colorMode == 0 && this.colorMaxX == 255 && this.colorMaxY == 255 && this.colorMaxZ == 255) {
            this.colorModeRGB255 = true;
        }
    }

    public void colorMode(int n, int n2, int n3, int n4) {
        this.colorMaxX = n2;
        this.colorMaxY = n3;
        this.colorMaxZ = n4;
        this.colorMode(n);
    }

    public void colorMode(int n, int n2, int n3, int n4, int n5) {
        this.colorMode(n, n2, n3, n4);
        this.colorMaxA = n5;
    }

    public int color(int n) {
        return this.color(n, this.colorMaxA);
    }

    public int color(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.colorMaxX) {
            n = this.colorMaxX;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.colorMaxA) {
            n2 = this.colorMaxA;
        }
        if (!this.colorModeRGB255) {
            n = n * 255 / this.colorMaxX;
        }
        if (this.colorMaxA != 255) {
            n2 = n2 * 255 / this.colorMaxA;
        }
        return n2 << 24 | n << 16 | n << 8 | n;
    }

    public int color(int n, int n2, int n3) {
        return this.color(n, n2, n3, this.colorMaxA);
    }

    public int color(int n, int n2, int n3, int n4) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.colorMaxX) {
            n = this.colorMaxX;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.colorMaxY) {
            n2 = this.colorMaxY;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > this.colorMaxZ) {
            n3 = this.colorMaxZ;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 > this.colorMaxA) {
            n4 = this.colorMaxA;
        }
        if (!this.colorModeRGB255) {
            if (this.colorMode == 0) {
                n = n * 255 / this.colorMaxX;
                n2 = n2 * 255 / this.colorMaxY;
                n3 = n3 * 255 / this.colorMaxZ;
            } else if (n2 == 0) {
                n = n3 * 255 / this.colorMaxZ;
                n2 = n3 * 255 / this.colorMaxZ;
                n3 = n3 * 255 / this.colorMaxZ;
            } else {
                int n5 = (n2 << 8) / this.colorMaxY;
                int n6 = (n3 << 8) / this.colorMaxZ;
                int n7 = n * 6 / this.colorMaxX % 6;
                int n8 = (n << 8) * 6 / this.colorMaxX - (n7 << 8);
                int n9 = this.midlet.mul(n6, 256 - n5);
                int n10 = this.midlet.mul(n6, 256 - this.midlet.mul(n5, n8));
                int n11 = this.midlet.mul(n6, 256 - this.midlet.mul(n5, 256 - n8));
                switch (n7) {
                    case 0: {
                        n = n6 * 255 >> 8;
                        n2 = n11 * 255 >> 8;
                        n3 = n9 * 255 >> 8;
                        break;
                    }
                    case 1: {
                        n = n10 * 255 >> 8;
                        n2 = n6 * 255 >> 8;
                        n3 = n9 * 255 >> 8;
                        break;
                    }
                    case 2: {
                        n = n9 * 255 >> 8;
                        n2 = n6 * 255 >> 8;
                        n3 = n11 * 255 >> 8;
                        break;
                    }
                    case 3: {
                        n = n9 * 255 >> 8;
                        n2 = n10 * 255 >> 8;
                        n3 = n6 * 255 >> 8;
                        break;
                    }
                    case 4: {
                        n = n11 * 255 >> 8;
                        n2 = n9 * 255 >> 8;
                        n3 = n6 * 255 >> 8;
                        break;
                    }
                    case 5: {
                        n = n6 * 255 >> 8;
                        n2 = n9 * 255 >> 8;
                        n3 = n10 * 255 >> 8;
                    }
                }
            }
        }
        if (n4 != 255) {
            n4 = n4 * 255 / this.colorMaxA;
        }
        return n4 << 24 | n << 16 | n2 << 8 | n3;
    }

    public void stroke(int n) {
        this.stroke = true;
        this.strokeColor = (n & 0xFF000000) == 0 && n <= this.colorMaxX ? this.color(n, this.colorMaxA) : n;
    }

    public void stroke(int n, int n2, int n3) {
        this.stroke = true;
        this.strokeColor = this.color(n, n2, n3, this.colorMaxA);
    }

    public void noStroke() {
        this.stroke = false;
    }

    public void fill(int n) {
        this.fill = true;
        this.fillColor = (n & 0xFF000000) == 0 && n <= this.colorMaxX ? this.color(n, this.colorMaxA) : n;
    }

    public void fill(int n, int n2, int n3) {
        this.fill = true;
        this.fillColor = this.color(n, n2, n3, this.colorMaxA);
    }

    public void noFill() {
        this.fill = false;
    }

    public void text(String string, int n, int n2) {
        if (this.textFont == null) {
            throw new RuntimeException("The current font has not yet been set with textFont()");
        }
        this.bufferg.setColor(this.fillColor);
        if (string.indexOf(10) >= 0) {
            this.text(string, n, n2 - this.textFont.baseline, Integer.MAX_VALUE, Integer.MAX_VALUE);
        } else {
            this.textFont.draw(this.bufferg, string, n, n2, this.textAlign);
        }
    }

    public void text(String string, int n, int n2, int n3, int n4) {
        String[] stringArray = this.textWrap(string, n3, n4);
        this.text(stringArray, n, n2, n3, n4);
    }

    public void text(String[] stringArray, int n, int n2, int n3, int n4) {
        if (this.textFont == null) {
            throw new RuntimeException("The current font has not yet been set with textFont()");
        }
        this.bufferg.setColor(this.fillColor);
        this.pushMatrix();
        this.clip(n, n2, n3, n4);
        int n5 = n;
        n2 += this.textFont.baseline;
        int n6 = stringArray.length;
        for (int i = 0; i < n6; ++i) {
            String string = stringArray[i];
            switch (this.textAlign) {
                case 0: {
                    n5 = n + (n3 - this.textWidth(string) >> 1);
                    break;
                }
                case 5: {
                    n5 = n + n3 - this.textWidth(string);
                }
            }
            this.textFont.draw(this.bufferg, string, n5, n2, 2);
            n2 += this.textLeading;
        }
        this.popMatrix();
    }

    public String[] textWrap(String string, int n, int n2) {
        if (this.textFont == null) {
            throw new RuntimeException("The current font has not yet been set with textFont()");
        }
        int n3 = n2 / this.textLeading;
        int n4 = string.length();
        Vector<String> vector = new Vector<String>();
        char[] cArray = new char[256];
        for (int i = 0; i < n4; ++i) {
            char c = string.charAt(i);
            if (c != ' ') {
                int n5 = 0;
                int n6 = -1;
                int n7 = 0;
                while (n7 <= n) {
                    if (i == n4) {
                        n6 = n5;
                        break;
                    }
                    c = string.charAt(i);
                    ++i;
                    cArray[n5] = c;
                    ++n5;
                    if (c == ' ') {
                        n6 = n5 - 1;
                        while (i < n4 && string.charAt(i) == ' ') {
                            ++i;
                            cArray[n5] = 32;
                            ++n5;
                        }
                    } else if (c == '\n') {
                        n6 = n5 - 1;
                        break;
                    }
                    n7 = this.textFont.charsWidth(cArray, 0, n5);
                }
                if (n6 >= 0) {
                    vector.addElement(new String(cArray, 0, n6));
                    i -= n5 - n6;
                } else {
                    vector.addElement(new String(cArray, 0, n5 - 1));
                    i -= 2;
                }
            }
            if (vector.size() == n3) break;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int textWidth(char c) {
        if (this.textFont == null) {
            throw new RuntimeException("The current font has not yet been set with textFont()");
        }
        return this.textFont.charWidth(c);
    }

    public int textWidth(String string) {
        if (this.textFont == null) {
            throw new RuntimeException("The current font has not yet been set with textFont()");
        }
        return this.textFont.stringWidth(string);
    }

    public void textAlign(int n) {
        if (n != 2 && n != 0 && n != 5) {
            throw new IllegalArgumentException("Invalid textAlign MODE value");
        }
        this.textAlign = n;
    }

    public void textLeading(int n) {
        this.textLeading = n;
    }

    protected void showNotify() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.width != n || this.height != n2) {
            this.sizeChanged(n, n2);
        }
        if (this.suspended) {
            this.midlet.resume();
            this.suspended = false;
        }
        this.midlet.start();
    }

    protected void hideNotify() {
        this.midlet.suspend();
        this.suspended = true;
    }

    protected void sizeChanged(int n, int n2) {
        this.width = this.midlet.width = n;
        this.height = this.midlet.height = n2;
        buffer = Image.createImage((int)n, (int)n2);
        this.bufferg = buffer.getGraphics();
        this.background(200);
    }
}

